<?php
ob_start('minify_html');

function minify_html($buffer)
{
    $search = [
        '/\>[^\S ]+/s',
        '/[^\S ]+\</s',
        '/(\s)+/s',
        '/<!--(.|\s)*?-->/'
    ];
    $replace = ['>', '<', '\\1', ''];
    return preg_replace($search, $replace, $buffer);
}

?>
<!DOCTYPE html>
<html lang="zxx">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="author" content="Sebastián Camargo">
    <title>Boot Campenesa</title>

    <link rel="shortcut icon" href="assets/images/favicon.png" type="image/x-icon">
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/aos.css">
    <link rel="stylesheet" href="assets/css/all.min.css">
    <link rel="stylesheet" href="assets/css/lightcase.css">
    <link rel="stylesheet" href="assets/css/swiper-bundle.min.css">

    <!-- main css for template -->
    <link rel="stylesheet" href="assets/css/style.css">
</head>

<body>
    <div class="preloader">
        <img src="assets/images/logo/preloader.gif" alt="Uevent">
    </div>
    <!-- ===============>> Preloader end here <<================= -->

    <!-- ========== Multipage Header Section Starts Here========== -->
    <header class="header-section">
        <div class="header-bottom">
            <div class="container">
                <div class="header-wrapper">
                    <div class="logo">
                        <a href="index.html">
                            <img src="assets/images/logo/logo2.png" alt="logo">
                        </a>
                    </div>
                    <div class="menu-area">
                        <ul class="menu">
                            <li>
                                <a href="#home">Inicio</a>
                            </li>

                            <li>
                                <a href="#Quienes-Somos">Quienes somos</a>
                            </li>
                            <li>
                                <a href="#feature">¿Qué es un Jam?</a>
                            </li>
                            <li>
                                <a href="#problematica">¿Qué es bootcamp?</a>
                            </li>
                            <li>
                                <a href="#agenda">Agenda</a>
                            </li>
                        </ul>
                        <div class="header-btn">
                            <a href="#" id="registrationModal" class="default-btn move-right" data-bs-toggle="modal"
                                data-bs-target="#modalRegistro">
                                <span>Regístrate <i class="fa-solid fa-arrow-right"></i></span>
                            </a>
                        </div>

                        <!-- toggle icons -->
                        <div class="header-bar d-lg-none">
                            <span></span>
                            <span></span>
                            <span></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>
    <!-- ========== Multipage Header Section Ends Here========== -->

    <button id="btnSubir" title="Volver arriba">
        <i class="fa-solid fa-arrow-up"></i>
    </button>
    <div id="asistenteInscripcion">
        <img src="https://cdn-icons-png.flaticon.com/128/1785/1785888.png" alt="Asistente" class="asistente-img">
        <div class="mensaje-burbuja">
            🗓️ ¡Las inscripciones cierran el <strong>04 de diciembre</strong>!
        </div>
    </div>
    