<!-- Modal de Registro -->
<div class="modal fade" id="modalRegistro" tabindex="-1" aria-labelledby="modalRegistroLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalRegistroLabel">
                    <i class="fa-solid fa-clipboard-list me-2"></i>Registro de Evento
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">X</button>
            </div>
            <div class="modal-body">
                <form id="formRegistro" novalidate>
                    <div class="row g-3">
                        <!-- Nombre completo -->
                        <div class="col-md-12">
                            <label for="nombreCompleto" class="form-label required-field">Nombre Completo</label>
                            <input type="text" class="form-control" id="nombreCompleto" name="nombreCompleto" required
                                minlength="3" maxlength="100" pattern="^[A-Za-zÁÉÍÓÚáéíóúÑñ\s]+$"
                                title="Ingrese solo letras y espacios." placeholder="Ejemplo: Juan Pérez">
                        </div>

                        <!-- Tipo de documento -->
                        <div class="col-md-6">
                            <label for="tipoDocumento" class="form-label required-field">Tipo de Documento</label>
                            <select class="form-select" id="tipoDocumento" name="tipo" required>
                                <option value="">Seleccione...</option>
                                <option value="Cedula de Ciudadania">Cédula de Ciudadanía</option>
                                <option value="Tarjeta de Identidad">Tarjeta de Identidad</option>
                                <option value="Cedula de Extranjeria">Cédula de Extranjería</option>
                                <option value="Pasaporte">Pasaporte</option>
                            </select>
                        </div>

                        <!-- Número de documento -->
                        <div class="col-md-6">
                            <label for="numeroDocumento" class="form-label required-field">Número de Documento</label>
                            <input type="text" class="form-control" id="numeroDocumento" name="numeroDocumento" required
                                minlength="5" maxlength="15" pattern="^[0-9]+$"
                                title="Ingrese solo números sin puntos ni comas." placeholder="Ejemplo: 1234567890">
                        </div>

                        <!-- Correo -->
                        <div class="col-md-6">
                            <label for="correo" class="form-label required-field">Correo Electrónico</label>
                            <input type="email" class="form-control" id="correo" name="correo" required maxlength="100"
                                pattern="^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-z]{2,}$"
                                title="Ingrese un correo electrónico válido (ejemplo@dominio.com)"
                                placeholder="Ejemplo: usuario@gmail.com">
                        </div>

                        <!-- Celular -->
                        <div class="col-md-6">
                            <label for="celular" class="form-label required-field">Celular</label>
                            <input type="tel" class="form-control" id="celular" name="celular" required minlength="10"
                                maxlength="10" pattern="^[0-9]{10}$"
                                title="Ingrese un número de 10 dígitos sin espacios ni guiones."
                                placeholder="Ejemplo: 3101234567">
                        </div>

                        <!-- Tipo de registro -->
                        <div class="col-md-12">
                            <label for="tipoEvento" class="form-label required-field">Tipo de Registro</label>
                            <select class="form-select" id="tipoEvento" name="tipoEvento" required>
                                <option value="">Seleccione el tipo de registro...</option>
                                <option value="asistente">Registro para Asistentes</option>
                                <option value="poster">Registro para Poster</option>
                            </select>
                        </div>
                    </div>

                    <!-- Campos adicionales dinámicos -->
                    <div id="camposAdicionales" class="mt-4"></div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                            <i class="fa-solid fa-times me-2"></i>Cancelar
                        </button>
                        <button type="button" class="btn btn-primary" id="btnEnviar">
                            <i class="fa-solid fa-paper-plane me-2"></i>Enviar Registro
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

