
document.addEventListener("DOMContentLoaded", () => {
    const buttons = document.querySelectorAll(".agenda-btn");
    const agendas = document.querySelectorAll(".agenda-content");
    function switchAgenda(selectedAgenda) {
        buttons.forEach(b => b.classList.remove("active"));
        agendas.forEach(agenda => {
            agenda.style.display = "none";
            agenda.classList.remove("active", "fade-in");
        });
        const activeButton = document.querySelector(`[data-agenda="${selectedAgenda}"]`);
        if (activeButton) {
            activeButton.classList.add("active");
        }
        const selectedElement = document.querySelector(`.${selectedAgenda}`);
        if (selectedElement) {
            selectedElement.style.display = "block";
            setTimeout(() => {
                selectedElement.classList.add("active", "fade-in");
            }, 50);
            setTimeout(() => {
                if (typeof AOS !== 'undefined') {
                    AOS.refresh();
                }
            }, 300);
        }
    }
    buttons.forEach(btn => {
        btn.addEventListener("click", () => {
            const selected = btn.getAttribute("data-agenda");
            switchAgenda(selected);
        });
    });
    const scheduleItems = document.querySelectorAll('.schedule__item');
    scheduleItems.forEach(item => {
        item.removeAttribute('data-aos');
        item.removeAttribute('data-aos-duration');
    });
});

document.addEventListener('DOMContentLoaded', function () {
    const track = document.getElementById('blogCarouselTrack');
    const slides = document.querySelectorAll('.blog-carousel__slide');
    const prevBtn = document.getElementById('blogCarouselPrev');
    const nextBtn = document.getElementById('blogCarouselNext');
    const indicatorsContainer = document.getElementById('blogCarouselIndicators');

    let currentIndex = 0;
    let autoSlideInterval;
    let isTransitioning = false;

    function getSlidesPerView() {
        if (window.innerWidth <= 768) return 1;
        if (window.innerWidth <= 992) return 2;
        return 3;
    }

    let slidesPerView = getSlidesPerView();
    const totalRealSlides = slides.length;

    function setupCarousel() {
        // Limpiar clones existentes
        const existingClones = track.querySelectorAll('.clone');
        existingClones.forEach(clone => clone.remove());

        // Calcular cuántos slides necesitamos para llenar la vista
        const neededClones = slidesPerView;

        // Clonar slides al inicio (últimos slides reales)
        for (let i = totalRealSlides - neededClones; i < totalRealSlides; i++) {
            const clone = slides[i].cloneNode(true);
            clone.classList.add('clone');
            track.insertBefore(clone, track.firstChild);
        }

        // Clonar slides al final (primeros slides reales)
        for (let i = 0; i < neededClones; i++) {
            const clone = slides[i].cloneNode(true);
            clone.classList.add('clone');
            track.appendChild(clone);
        }

        // Posicionar en el primer slide real
        currentIndex = neededClones;
        updateCarousel(false);
    }

    function createIndicators() {
        indicatorsContainer.innerHTML = '';
        const totalPages = Math.ceil(totalRealSlides / slidesPerView);

        for (let i = 0; i < totalPages; i++) {
            const indicator = document.createElement('button');
            indicator.classList.add('blog-carousel__indicator');
            if (i === 0) indicator.classList.add('active');
            indicator.addEventListener('click', () => goToSlide(i));
            indicatorsContainer.appendChild(indicator);
        }
    }

    function updateCarousel(transition = true) {
        if (!transition) {
            track.style.transition = 'none';
        } else {
            track.style.transition = 'transform 0.5s ease';
        }

        const allSlides = track.querySelectorAll('.blog-carousel__slide');
        const slideWidth = slides[0].offsetWidth + parseInt(getComputedStyle(slides[0]).marginRight || 0);
        const offset = currentIndex * slideWidth;
        track.style.transform = `translateX(-${offset}px)`;

        // Actualizar indicadores
        const realIndex = (currentIndex - slidesPerView + totalRealSlides) % totalRealSlides;
        const indicatorIndex = Math.floor(realIndex / slidesPerView);
        const indicators = document.querySelectorAll('.blog-carousel__indicator');
        indicators.forEach((indicator, index) => {
            indicator.classList.toggle('active', index === indicatorIndex);
        });

        if (!transition) {
            // Force reflow
            track.offsetHeight;
            track.style.transition = 'transform 0.5s ease';
        }
    }

    function goToSlide(pageIndex) {
        currentIndex = slidesPerView + (pageIndex * slidesPerView);
        updateCarousel();
        resetAutoSlide();
    }

    function nextSlide() {
        if (isTransitioning) return;
        isTransitioning = true;

        currentIndex++;
        updateCarousel();

        setTimeout(() => {
            const allSlides = track.querySelectorAll('.blog-carousel__slide');
            const totalSlides = allSlides.length;

            // Si estamos en los clones finales, saltar a los slides reales
            if (currentIndex >= totalSlides - slidesPerView) {
                currentIndex = slidesPerView;
                updateCarousel(false);
            }
            isTransitioning = false;
        }, 500);
    }

    function prevSlide() {
        if (isTransitioning) return;
        isTransitioning = true;

        currentIndex--;
        updateCarousel();

        setTimeout(() => {
            // Si estamos en los clones iniciales, saltar a los slides reales finales
            if (currentIndex < slidesPerView) {
                const allSlides = track.querySelectorAll('.blog-carousel__slide');
                currentIndex = allSlides.length - slidesPerView * 2;
                updateCarousel(false);
            }
            isTransitioning = false;
        }, 500);
    }

    function startAutoSlide() {
        autoSlideInterval = setInterval(nextSlide, 4000);
    }

    function resetAutoSlide() {
        clearInterval(autoSlideInterval);
        startAutoSlide();
    }

    // Event listeners
    prevBtn.addEventListener('click', function (e) {
        e.preventDefault();
        prevSlide();
        resetAutoSlide();
    });

    nextBtn.addEventListener('click', function (e) {
        e.preventDefault();
        nextSlide();
        resetAutoSlide();
    });

    track.addEventListener('mouseenter', () => {
        clearInterval(autoSlideInterval);
    });

    track.addEventListener('mouseleave', () => {
        startAutoSlide();
    });

    let resizeTimer;
    window.addEventListener('resize', function () {
        clearTimeout(resizeTimer);
        resizeTimer = setTimeout(function () {
            const newSlidesPerView = getSlidesPerView();
            if (newSlidesPerView !== slidesPerView) {
                slidesPerView = newSlidesPerView;
                setupCarousel();
                createIndicators();
            }
        }, 250);
    });

    // Inicializar
    setupCarousel();
    createIndicators();
    startAutoSlide();
});

document.addEventListener("DOMContentLoaded", () => {
    const btn = document.getElementById("btnSubir");
    const toggleButton = () => {
        const scrollY = window.scrollY || document.documentElement.scrollTop;
        if (scrollY > 200) {
            btn.style.display = "flex";
        } else {
            btn.style.display = "none";
        }
    };
    
    toggleButton();
    window.addEventListener("scroll", toggleButton);
    btn.addEventListener("click", () => {
        window.scrollTo({ top: 0, behavior: "smooth" });
    });

    const asistente = document.getElementById("asistenteInscripcion");
    asistente.style.display = "none";
    setTimeout(() => {
        asistente.style.display = "flex";
    }, 2000);
});


document.addEventListener("DOMContentLoaded", function () {
    const tipoEventoSelect = document.getElementById('tipoEvento');
    const camposAdicionalesDiv = document.getElementById('camposAdicionales');
    const btnEnviar = document.getElementById('btnEnviar');
    const formRegistro = document.getElementById('formRegistro');


    // Centros de Formación SENA Regional Atlántico
    const centrosSENA = [
        'Centro para el Desarrollo del Hábitat y la Construcción',
        'Centro de Comercio y Servicios',
        'Centro Industrial y de Aviación',
        'Centro Nacional Colombo Alemán',
        'Centro para el Desarrollo Agroecológico y Agroindustrial'
    ];

    // Mostrar campos según tipo de evento
    tipoEventoSelect.addEventListener('change', function () {
        const tipo = this.value;
        camposAdicionalesDiv.innerHTML = '';

        if (tipo === 'asistente') {
            camposAdicionalesDiv.innerHTML = `
                <h6 class="mb-3 text-primary"><i class="fa-solid fa-user me-2"></i>Información del Asistente</h6>
                <div class="row g-3">
                    <div class="col-md-12">
                        <label for="institucion" class="form-label required-field">Institución de Formación</label>
                        <input type="text" class="form-control" id="institucion" required>
                    </div>
                    <div class="col-md-6">
                        <label for="edad" class="form-label required-field">Edad</label>
                        <input type="number" class="form-control" id="edad" min="1" max="120" required>
                    </div>
                    <div class="col-md-6">
                        <label for="centroSena" class="form-label required-field">Centro de Formación SENA</label>
                        <select class="form-select" id="centroSena" required>
                            <option value="">Seleccione...</option>
                            ${centrosSENA.map(centro => `<option value="${centro}">${centro}</option>`).join('')}
                        </select>
                    </div>
                </div>
            `;
        } else if (tipo === 'poster') {
            camposAdicionalesDiv.innerHTML = `
                <h6 class="mb-3 text-primary"><i class="fa-solid fa-image me-2"></i>Información del Poster</h6>
                <div class="row g-3">
                    <div class="col-md-12">
                        <label for="institucionPoster" class="form-label required-field">Institución de Formación</label>
                        <input type="text" class="form-control" id="institucionPoster" required>
                    </div>
                    <div class="col-md-6">
                        <label for="edadPoster" class="form-label required-field">Edad</label>
                        <input type="number" class="form-control" id="edadPoster" min="1" max="120" required>
                    </div>
                    <div class="col-md-6">
                        <label for="centroSenaPoster" class="form-label required-field">Centro de Formación SENA</label>
                        <select class="form-select" id="centroSenaPoster" required>
                            <option value="">Seleccione...</option>
                            ${centrosSENA.map(centro => `<option value="${centro}">${centro}</option>`).join('')}
                        </select>
                    </div>
                    <div class="col-md-12">
                        <label for="ejeTematicoSelect" class="form-label required-field">Eje Temático</label>
                        <select class="form-select" id="ejeTematicoSelect" required>
                            <option value="">Seleccione...</option>
                            <option value="tecnologia">Tecnología e Innovación</option>
                            <option value="salud">Salud y Bienestar</option>
                            <option value="ambiente">Medio Ambiente</option>
                            <option value="social">Desarrollo Social</option>
                            <option value="educacion">Educación</option>
                            <option value="agroindustria">Agroindustria</option>
                            <option value="construccion">Construcción</option>
                            <option value="otro">Otro</option>
                        </select>
                    </div>
                    <div class="col-md-12">
                        <label for="descripcionProyecto" class="form-label required-field">Descripción del Proyecto</label>
                        <textarea class="form-control" id="descripcionProyecto" rows="4" required></textarea>
                    </div>
                    <div class="col-md-12">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="autorizacionDatos" required>
                            <label class="form-check-label required-field" for="autorizacionDatos">
                                Autorización para el uso de datos personales (Ley 1581 de 2012)
                            </label>
                        </div>
                    </div>
                </div>
            `;
        }
    });

    // Enviar datos con AJAX (fetch)
    btnEnviar.addEventListener('click', function () {
        if (formRegistro.checkValidity()) {
            const datos = {
                nombreCompleto: document.getElementById('nombreCompleto').value,
                tipoDoc: document.getElementById('tipoDocumento').value,
                numDoc: document.getElementById('numeroDocumento').value,
                correo: document.getElementById('correo').value,
                celular: document.getElementById('celular').value,
                tipo: document.getElementById('tipoEvento').value
            };

            if (datos.tipo === 'asistente') {
                datos.institucion = document.getElementById('institucion').value;
                datos.edad = document.getElementById('edad').value;
                datos.centro = document.getElementById('centroSena').value;
            } else if (datos.tipo === 'poster') {
                datos.institucion = document.getElementById('institucionPoster').value;
                datos.edad = document.getElementById('edadPoster').value;
                datos.centro = document.getElementById('centroSenaPoster').value;
                datos.eje_poster = document.getElementById('ejeTematicoSelect').value;
                datos.descPonencia = document.getElementById('descripcionProyecto').value;
                datos.autoriza = document.getElementById('autorizacionDatos').checked ? 'Sí' : 'No';
            }

            fetch('assets/sql/insertar_registro.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(datos)
            })
                .then(res => res.json())
                .then(response => {
                    if (response.status === 'success') {
                        alert('✅ Registro insertado correctamente');
                        bootstrap.Modal.getInstance(document.getElementById('modalRegistro')).hide();
                        formRegistro.reset();
                        camposAdicionalesDiv.innerHTML = '';
                    } else {
                        alert('⚠️ Error al insertar: ' + response.message);
                    }
                })
                .catch(error => {
                    console.error('Error en la solicitud:', error);
                    alert('❌ Ocurrió un error al enviar los datos.');
                });
        } else {
            formRegistro.reportValidity();
        }
    });

    // Limpiar formulario al cerrar el modal
    document.getElementById('modalRegistro').addEventListener('hidden.bs.modal', function () {
        formRegistro.reset();
        camposAdicionalesDiv.innerHTML = '';
    });
});
