<?php
header('Content-Type: application/json');
include 'conexion.php';

$data = json_decode(file_get_contents('php://input'), true);

if (!$data || empty($data['nombreCompleto']) || empty($data['tipo'])) {
    echo json_encode(['status' => 'error', 'message' => 'Datos incompletos']);
    exit;
}

function limpiar($valor) {
    return htmlspecialchars(strip_tags(trim($valor)));
}

$nombreCompleto = limpiar($data['nombreCompleto']);
$edad = isset($data['edad']) ? intval($data['edad']) : null;
$tipoDoc = limpiar($data['tipoDoc'] ?? '');
$numDoc = limpiar($data['numDoc'] ?? '');
$correo = limpiar($data['correo'] ?? '');
$celular = limpiar($data['celular'] ?? '');
$institucion = limpiar($data['institucion'] ?? '');
$centro = limpiar($data['centro'] ?? '');
$tipo = limpiar($data['tipo']);
$eje_poster = limpiar($data['eje_poster'] ?? '');
$descPonencia = limpiar($data['descPonencia'] ?? '');
$autoriza = limpiar($data['autoriza'] ?? 'No');

// Insertar datos en la tabla
$sql = "INSERT INTO registros (
    nombre_completo, edad, tipo_doc, num_doc, correo, celular, institucion, centro, tipo,
    eje_poster, desc_ponencia, autoriza
) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

$stmt = $conn->prepare($sql);
if (!$stmt) {
    echo json_encode(['status' => 'error', 'message' => 'Error en preparación: ' . $conn->error]);
    exit;
}

$stmt->bind_param(
    "sissssssssss",
    $nombreCompleto,
    $edad,
    $tipoDoc,
    $numDoc,
    $correo,
    $celular,
    $institucion,
    $centro,
    $tipo,
    $eje_poster,
    $descPonencia,
    $autoriza
);

if ($stmt->execute()) {
    echo json_encode(['status' => 'success', 'message' => 'Registro guardado correctamente']);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Error al registrar: ' . $stmt->error]);
}

$stmt->close();
$conn->close();
?>
