<?php

// =======================================
// INICIO: MINIFICADOR DE HTML AUTOMÁTICO
// =======================================
ob_start('minify_html');

function minify_html($buffer)
{
    $search = [
        '/\>[^\S ]+/s',      // elimina espacios después de etiquetas
        '/[^\S ]+\</s',      // elimina espacios antes de etiquetas
        '/(\s)+/s',          // elimina espacios múltiples
        '/<!--(.|\s)*?-->/'  // elimina comentarios
    ];
    $replace = ['>', '<', '\\1', ''];
    return preg_replace($search, $replace, $buffer);
}
// =======================================
// FIN: MINIFICADOR DE HTML AUTOMÁTICO
// =======================================

require_once "config/router/config.php";
$page = basename($_SERVER['PHP_SELF']);
$siteName = "Tesoros del Atlántico";
$siteUrl = "https://tesorosdelatlantico.com/";
$siteDescription = "Tesoros del Atlántico: descubre el turismo, el agro, la moda, la cultura y la gastronomía del Departamento del Atlántico. Vive la experiencia única del Caribe colombiano.";
$siteKeywords = "Atlántico, turismo Atlántico, cultura Atlántico, gastronomía, moda, agro, Caribe colombiano, Barranquilla, eventos, ferias, rutas turísticas";
$siteAuthor = "Tesoros del Atlántico";
$siteImage = "https://tesorosdelatlantico.com/assets/img/logo/logo-tesoros-plataforma.png"; // cambia a la imagen real de portada


if ($page == 'nosotros.php') {
    $siteName = "Nosotros - Tesoros del Atlántico";
    $siteDescription = "Conoce la misión, visión y el equipo detrás de Tesoros del Atlántico, la plataforma que impulsa el turismo, la cultura, la gastronomía, la moda y el agro en el Departamento del Atlántico.";
} elseif ($page == 'servicios.php') {
    $siteName = "Trámites y Servicios - Tesoros del Atlántico";
    $siteDescription = "Explora los trámites y servicios ofrecidos por Tesoros del Atlántico para apoyar a emprendedores y empresarios en el sector turístico, cultural, gastronómico, de moda y agroindustrial.";
} elseif ($page == 'tesoros.php') {
    $siteName = "Tesoros - Tesoros del Atlántico";
    $siteDescription = "Descubre los tesoros del Departamento del Atlántico: destinos turísticos, eventos culturales, experiencias gastronómicas, moda local y productos agroindustriales que reflejan la riqueza del Caribe colombiano.";
} elseif ($page == 'vitrina.php') {
    $siteName = "Tiendas - Tesoros del Atlántico";
    $siteDescription = "Explora la Tiendas de Tesoros del Atlántico, donde encontrarás una selección exclusiva de productos y servicios destacados en turismo, cultura, gastronomía, moda y agroindustria del Departamento del Atlántico.";
} elseif ($page == 'contacto.php') {
    $siteName = "Contacto - Tesoros del Atlántico";
    $siteDescription = "Ponte en contacto con Tesoros del Atlántico para consultas, sugerencias o colaboración. Estamos aquí para ayudarte a descubrir y promover los tesoros del Departamento del Atlántico.";
} elseif ($page == 'noticias.php') {
    $siteName = "Noticias - Tesoros del Atlántico";
    $siteDescription = "Mantente informado con las últimas noticias sobre turismo, cultura, gastronomía, moda y agroindustria en el Departamento del Atlántico. Descubre eventos, ferias y novedades en Tesoros del Atlántico.";
} elseif ($page == 'noticia-detalle.php' && isset($_GET['nombre_noticia'])) {
    // Aquí podrías agregar lógica para obtener el título y descripción específicos de la noticia desde una base de datos o un array
} else {
    $siteName = "Tesoros del Atlántico";
    $siteDescription = "Tesoros del Atlántico: descubre el turismo, el agro, la moda, la cultura y la gastronomía del Departamento del Atlántico. Vive la experiencia única del Caribe colombiano.";
}

?>

<!doctype html>
<html class="no-js" lang="es">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="author" content="Tesoros del Atlántico - Sebastián Camargo">
    <title><?= htmlspecialchars($siteName) ?></title>

    <!-- SEO -->
    <meta name="author" content="<?= $siteAuthor ?>">
    <meta name="description" content="<?= $siteDescription ?>">
    <meta name="keywords" content="<?= $siteKeywords ?>">
    <meta name="robots" content="INDEX,FOLLOW">

    <!-- Open Graph / Facebook -->
    <meta property="og:title" content="<?= $siteName ?>">
    <meta property="og:description" content="<?= $siteDescription ?>">
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?= $siteUrl ?>">
    <meta property="og:image" content="<?= $siteImage ?>">
    <meta property="og:locale" content="es_CO">

    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="<?= $siteName ?>">
    <meta name="twitter:description" content="<?= $siteDescription ?>">
    <meta name="twitter:image" content="<?= $siteImage ?>">

    <!-- Mobile Specific Metas -->
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- Favicons -->
    <link rel="apple-touch-icon" sizes="180x180" href="<?= BASE_URL ?>assets/img/icon/favicon.ico">
    <link rel="icon" type="image/png" sizes="32x32" href="<?= BASE_URL ?>assets/img/icon/favicon.ico">
    <link rel="icon" type="image/png" sizes="16x16" href="<?= BASE_URL ?>assets/img/icon/favicon.ico">
    <link rel="manifest" href="<?= BASE_URL ?>assets/img/favicons/manifest.json">
    <meta name="msapplication-TileColor" content="#ffffff">
    <meta name="msapplication-TileImage" content="<?= BASE_URL ?>assets/img/favicons/ms-icon-144x144.png">
    <meta name="theme-color" content="#ffffff">

    <!--==============================
      Google Fonts
    ============================== -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Inter:wght@100..900&family=Manrope:wght@200..800&family=Montez&display=swap"
        rel="stylesheet">

    <!--==============================
        All CSS File
    ============================== -->
    <!-- Bootstrap -->
    <link rel="stylesheet" href="<?= BASE_URL ?>assets/css/bootstrap.min.css">
    <!-- Fontawesome Icon -->
    <link rel="stylesheet" href="<?= BASE_URL ?>assets/css/fontawesome.min.css">
    <!-- Magnific Popup -->
    <link rel="stylesheet" href="<?= BASE_URL ?>assets/css/magnific-popup.min.css">
    <!-- Swiper css -->
    <link rel="stylesheet" href="<?= BASE_URL ?>assets/css/swiper-bundle.min.css">
    <!-- Theme Custom CSS -->
    <link rel="stylesheet" href="<?= BASE_URL ?>assets/css/style.css">
    <!-- Otros CSS -->